/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.util.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;

public record ResourceOrTag<T>(Optional<TagKey<T>> tag, Optional<ResourceKey<T>> key) {
    public static final MapCodec<ResourceOrTag<EntityType<?>>> ENTITY_TYPE_CODEC = ResourceOrTag.createCodec(Registries.ENTITY_TYPE);
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceOrTag<EntityType<?>>> ENTITY_TYPE_STREAM_CODEC = ResourceOrTag.createStreamCodec(Registries.ENTITY_TYPE);
    public static final MapCodec<ResourceOrTag<Item>> ITEM_CODEC = ResourceOrTag.createCodec(Registries.ITEM);
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceOrTag<Item>> ITEM_STREAM_CODEC = ResourceOrTag.createStreamCodec(Registries.ITEM);
    public static final MapCodec<ResourceOrTag<Structure>> STRUCTURE_CODEC = ResourceOrTag.createCodec(Registries.STRUCTURE);
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceOrTag<Structure>> STRUCTURE_STREAM_CODEC = ResourceOrTag.createStreamCodec(Registries.STRUCTURE);

    public static <T> MapCodec<ResourceOrTag<T>> createCodec(ResourceKey<Registry<T>> registry) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)registry).optionalFieldOf("tag").forGetter(rec -> rec.tag), (App)ResourceKey.codec((ResourceKey)registry).optionalFieldOf("key").forGetter(rec -> rec.key)).apply((Applicative)instance, ResourceOrTag::new));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, ResourceOrTag<T>> createStreamCodec(ResourceKey<Registry<T>> registry) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)TagKey.codec(registry))), ResourceOrTag::tag, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceKey.streamCodec(registry)), ResourceOrTag::key, ResourceOrTag::new);
    }

    public void apply(Consumer<TagKey<T>> tagConsumer, Consumer<ResourceKey<T>> keyConsumer) {
        this.tag.ifPresent(tagConsumer);
        this.key.ifPresent(keyConsumer);
    }

    public <R> Optional<R> map(Function<TagKey<T>, R> tagConsumer, Function<ResourceKey<T>, R> keyConsumer) {
        return this.tag.map(tagConsumer).or(() -> this.key.map(keyConsumer));
    }

    public static <T> ResourceOrTag<T> tag(TagKey<T> tag) {
        return new ResourceOrTag<T>(Optional.of(tag), Optional.empty());
    }

    public static <T> ResourceOrTag<T> key(ResourceKey<T> key) {
        return new ResourceOrTag<T>(Optional.empty(), Optional.of(key));
    }

    public static ResourceOrTag<Item> item(Item item) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)item));
        return ResourceOrTag.key(key);
    }

    public static ResourceOrTag<Block> block(Block block) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)block));
        return ResourceOrTag.key(key);
    }
}

